<?php

namespace app\models;

use Yii;
use yii\base\Model;
use yii\validators\RegularExpressionValidator;

/**
 * LoginForm is the model behind the login form.
 *
 * @property-read User|null $user
 *
 */
class RegisterForm extends Model
{
    public $name;
    public $surname;
    public $patronumic;
    public $email;
    public $phone_number;
    public $address ;
    public $password;

    
  

    /**
     * @return array the validation rules.
     */
    public function rules()
    {
        return [
            [['name','patronumic','surname', 'phone_number', 'email' ,'password'], 'required'],

            [['phone_number', 'email'],'unique','targetClass' => '\app\models\User',
                'message' => 'Такие данные уже есть в системе',
            ],

            [
                'phone_number', RegularExpressionValidator::class,
                'pattern' => '/^\+7\(\d{3}\)-\d{3}-\d{2}-\d{2}$/',
                'message' => 'Форма ввода: +7(XXX)-XXX-XX-XX',
            ],

            [['name','surname','patronumic'], RegularExpressionValidator::class,
                'pattern' => '/^[а-яА-ЯёЁ\s]+$/u',
                'message' => 'Разрешены символы (кириллица, пробел)',
            ],    

            ['email', 'email'],

            ['password', 'string', 'min' => 6],

           

         

        ];
    }

    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
          
            'name' => Yii::t('app', 'Имя'),
            'surname' => Yii::t('app', 'фамилия'),
            'patronumic' => Yii::t('app', 'отчество'),
            'phone_number' => Yii::t('app', 'Номер телефона'),
            'email' => Yii::t('app', 'Электронная почта'),
          
            'password' => Yii::t('app', 'Пароль'),
           
          
        ];
    }

    function register()
    {
        if(!$this->validate()){
            return null;
        }
        $user = new User();

      
        $user->email = $this->email;
       
        $user->phone_number = $this->phone_number;
        $user->name = $this->name;
        $user->surname = $this->surname;
        $user->patronumic = $this->patronumic;
        $user->password = Yii::$app->security->generatePasswordHash($this->password);

        return $user->save() ? $user : null;
    }
}
