<?php

namespace app\models;

use yii\db\ActiveRecord;

class Review extends ActiveRecord
{
    public static function tableName()
    {
        return 'reviews';
    }

    public function rules()
    {
        return [
            [['author_name', 'rating', 'comment'], 'required'],
            [['rating'], 'integer', 'min' => 1, 'max' => 5],
            [['comment'], 'string'],
            [['date'], 'safe'],
            [['author_name'], 'string', 'max' => 255],
            [['status'], 'in', 'range' => ['pending', 'approved', 'rejected']],
            [['category_id'], 'integer'], // Добавляем правило для category_id
            [['category_id'], 'exist', 'skipOnError' => true, 'targetClass' => Category::class, 'targetAttribute' => ['category_id' => 'id']], // Проверяем, что category_id существует
        ];
    }

    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'author_name' => 'Автор',
            'rating' => 'Рейтинг',
            'comment' => 'Комментарий',
            'date' => 'Дата',
            'status' => 'Статус',
            'category_id' => 'Категория',
        ];
    }

    // Связь с категорией
    public function getCategory()
    {
        return $this->hasOne(Category::class, ['id' => 'category_id']);
    }
}