<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "send".
 *
 * @property int $id
 * @property int $user_id
 * @property int $numbers_id
 * @property int $dost_id

 * @property int $pay_id
 * @property int $desc_usluga
 * @property int $status
 */
class Send extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'send';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['user_id', 'numbers_id', 'dost_id',  'pay_id',   ], 'required'],
            [['user_id', 'numbers_id', 'pay_id','dost_id', 'status'], 'integer'],
            [[ 'desc_usluga', 'time'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'user_id' => Yii::t('app', 'ФИО'),
            'numbers_id' => Yii::t('app', 'инструмент'),
            'pay_id' => Yii::t('app', 'Оплата'),
            'date' => Yii::t('app', 'дата начало аренды'),
            'kolvo' => Yii::t('app', 'количество дней аренды'),
            'dost_id' => Yii::t('app', 'способ доставки'),
           
            'desc_usluga' => Yii::t('app', 'Ваш адрес'),
            'status' => Yii::t('app', 'Статус'),
        ];
    }

    public function getStatus(){
        switch ($this->status){
            case 0:
                return 'В работе';
                case 1:
                    return 'Выполнено';
                    case 2:
                        return 'Отменено';
                        default:
                        return 'Ошибка';
        }
    }

    /**
     * Gets query for [[User]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }

    /**
     * Gets query for [[Pay]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPay()
    {
        return $this->hasOne(Pay::class, ['id' => 'pay_id']);
    }

    /**
     * Gets query for [[Pay]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getNumbers()
    {
        return $this->hasOne(Numbers::class, ['id' => 'numbers_id']);
    }
    /**
     * Gets query for [[Pay]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getDost()
    {
        return $this->hasOne(Dost::class, ['id' => 'dost_id']);
    }
}
