<?php

use app\models\Send;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/** @var yii\web\View $this */
/** @var app\models\SendSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = Yii::t('app', 'Заявки');
?>
<div class="send-index">

    <h1><?= Html::encode($this->title) ?></h1>


    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],


            ['attribute'=>'имя',
            'value' =>'user.name'],
                        ['attribute'=>'фамилия',
            'value' =>'user.surname'],
                        ['attribute'=>'отчество',
            'value' =>'user.patronumic'],

            ['attribute'=>'numbers_id',
            'value' =>'numbers.name'],
             ['attribute'=>'dost_id',
            'value' =>'dost.name'],
            'desc_usluga',
            'kolvo',
            'date',

            ['attribute'=>'pay_id',
            'value' =>'pay.name'],

            ['attribute'=>'status',
            'value' => function ($data){
                return $data->getStatus($data->status);
            }
        ],
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, Send $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id]);
                 }
            ],
        ],
    ]); ?>


</div>
