<?php

/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use app\widgets\Alert;
use yii\bootstrap5\Breadcrumbs;
use yii\bootstrap5\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;

AppAsset::register($this);

$this->registerCsrfMetaTags();
$this->registerMetaTag(['charset' => Yii::$app->charset], 'charset');
$this->registerMetaTag(['name' => 'viewport', 'content' => 'width=device-width, initial-scale=1, shrink-to-fit=no']);
$this->registerMetaTag(['name' => 'description', 'content' => $this->params['meta_description'] ?? '']);
$this->registerMetaTag(['name' => 'keywords', 'content' => $this->params['meta_keywords'] ?? '']);
$this->registerLinkTag(['rel' => 'icon', 'type' => 'image/x-icon', 'href' => Yii::getAlias('@web/favicon.ico')]);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>" class="h-100">
<head>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
</head>
<body class="d-flex flex-column h-100">
<?php $this->beginBody() ?>

<header id="header">
    <?php
    NavBar::begin([
        'brandLabel' =>'<img src="../img/logo14.png" style="border-radius=100%; width:150px; height:50px; background-size:cover; object-fit:cover;">',
        'brandUrl' => ['/site/index'],
        'options' => ['class' => 'navbar-expand-md navbar-light bg-light fixed-top']
    ]);
    echo Nav::widget([
        'options' => ['class' => 'navbar-nav'],
        'items' => [
            ['label' => 'Главная', 'url' => ['/site/index'], 'visible'=> !Yii::$app->user->isGuest && !Yii::$app->user->identity->is_admin ==1],
           
           
            ['label' => 'Заявки', 'url' => ['/send/index'], 'visible'=> !Yii::$app->user->isGuest && !Yii::$app->user->identity->is_admin ==1],
            ['label' => 'Сформировать заявку', 'url' => ['/site/send'], 'visible'=> !Yii::$app->user->isGuest  && !Yii::$app->user->identity->is_admin ==1],
            ['label' => 'Админ-панель', 'url' => ['/admin/send'],'visible'=> !Yii::$app->user->isGuest && Yii::$app->user->identity->is_admin ==1],
            ['label' => 'Регистрация', 'url' => ['/site/register'], 'visible'=> Yii::$app->user->isGuest],
            Yii::$app->user->isGuest
                ? ['label' => 'Авторизация', 'url' => ['/site/login']]
                : '<li class="nav-item">'
                    . Html::beginForm(['/site/logout'])
                    . Html::submitButton(
                        'Выйти',
                        ['class' => 'nav-link btn btn-link logout','style'=> 'background-color: rgb(68,0,255,0); color:#a2a2a2;']
                    )
                    . Html::endForm()
                    . '</li>'
        ]
    ]);
    NavBar::end();
    ?>
</header>

<main id="main" class="flex-shrink-0" role="main">
    <div class="container">
        <?php if (!empty($this->params['breadcrumbs'])): ?>
            <?= Breadcrumbs::widget(['links' => $this->params['breadcrumbs']]) ?>
        <?php endif ?>
        <?= Alert::widget() ?>
        <?= $content ?>
    </div>
</main>

<footer id="footer" class="mt-auto py-3 bg-light">
    <div class="container">
        <div class="row text-muted">
            <div class="col-md-6 text-center text-md-start">&copy; арендла строительной техники<?= date('Y') ?></div>
            <div class="col-md-6 text-center text-md-end">Контакты: <br>Тел. 8 800 555 35 35 <br></div>
        </div>
    </div>
</footer>

<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
