
<?php

use app\models\Send;
use yii\data\ActiveDataProvider;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/** @var yii\web\View $this */
/** @var app\models\SendSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = Yii::t('app', 'Заявки');
?>
<div class="send-index " style="margin-top:3%;">

    <h1><?= Html::encode($this->title) ?></h1>
<br>
    <p>
        <?= Html::a(Yii::t('app', 'Сформировать заявку'), ['site/send'], ['class' => 'btn btn-primary']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'dataProvider' => new ActiveDataProvider([
            'query' => Send::find()->where(['user_id'=> Yii::$app->user->id]),
        ]),
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            ['attribute'=>'numbers_id',
            'value' =>'numbers.name'],
            'desc_usluga',
            ['attribute'=>'pay_id',
            'value' =>'pay.name'],
             ['attribute'=>'date',
            'value' =>'date'],
             ['attribute'=>'dost_id',
            'value' =>'dost.name'],
             'kolvo',

            ['attribute'=>'status',
            'value' => function ($data){
                return $data->getStatus($data->status);
            }
        ],

            ['attribute'=>'Редактировать',
            'content' => function ($model,$key,$index,$column){

                if($model->status == 0){
                    return "<a class='btn btn-dark' href='" . Url::to(['send/update','id'=>$model->id]) ."'> Редактировать </a>";
                } else{
                    return "Вы не можете редактировать т.к заявка - " . ' ' . $model->getStatus();
                }
            }
        ],

        ['attribute'=>'Посмотреть всю информацию',
        'content' => function ($model,$key,$index,$column){
                return "<a class='btn btn-dark' href='" . Url::to(['send/view','id'=>$model->id]) ."'> Посмотреть </a>";
        }
        ],
        
        ],
        
    ]); ?>


</div>

