<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/** @var yii\web\View $this */
/** @var app\models\Send $model */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Заявки'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="send-view">

    <h1><?= Html::encode($this->title) ?></h1>
    <p>
        <?= Html::a('Обновить', ['update', 'id' => $model->id], ['class' => 'btn btn-dark']) ?>
        <?= Html::a('Удалить', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-dark',
            'data' => [
                'confirm' => 'Вы уверены, что хотите удалить этот элемент?',
                'method' => 'post',
            ],
        ]) ?>
    </p>
    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [

            ['attribute'=>'user.name',
            'label' =>'имя'],
            ['attribute'=>'user.surname',
            'label' =>'фамилия '],
            ['attribute'=>'user.patronumic',
            'label' =>'отчество'],

            ['attribute'=>'numbers.name',
            'label' =>'инструмент'],
            'desc_usluga',
            ['attribute'=>'dost.name',
            'label' =>'способ доставки'],
         

            ['attribute'=>'pay.name',
            'label' =>'Тип оплаты'],
            'desc_usluga',

            ['attribute'=>'status',
            'value' => function ($data){
                return $data->getStatus($data->status);
            }
        ],
        ],
    ]) ?>

</div>
