<?php

/** @var yii\web\View $this */

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Личный кабинет';
?>
<div class="site-about">
    <div class="container">
        <div class="row">
            <div class="col-md-auto">
                <div class="container text-center">
                    <div class="col align-items-start">
                        <div class="col">
                            <?php if($information) :?>
                            <img src="../uploads/<?= $information->photo ?>" alt="" class="img_avatar">
                            <?php endif; ?>
                        </div>
                        <br>
                        <div class="col">
                            <a href=<?= Url::to(['user/update', 'id' => Yii::$app->user->id]) ?> class="btn btn-primary">Изменить данные</a>
                            <a href=<?= Url::to(['site/switchpassword']) ?> class="btn btn-light">Сменить пароль</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="container">
                    <h2>Персональные данные</h2>
                    <div class="row back">
                        <div class="col">
                            <h5>ФИО</h5>
                            <span><?= $user->surname . ' ' . $user->patronymic . ' ' . $user->name ?></span>
                        </div>
                        <div class="col">
                            <h5>Логин</h5>
                            <span><?= $user->login ?></span>
                        </div>
                        <div class="col">
                            <h5>Номер телефона</h5>
                            <span><?= $user->phone ?></span>
                        </div>
                        <div class="col">
                            <h5>Email</h5>
                            <span><?= $user->email ?></span>
                        </div>
                    </div>
                </div>
                <br>
                <div class="col">
                    <div class="container">
                        <h3>Личная информация</h3>
                        <?php if($information) : ?>
                        <div class="row back">
                            <div class="col-md-auto">
                                <h5>Дата рождения</h5>
                                <span><?= $information->birthday ?></span>
                            </div>
                            <div class="col-md-auto">
                            <h5>Пол</h5>
                            <span><?= $information->getGender($information->gender) ?></span>
                            </div>
                            <div class="col-md-auto">
                            <h5>Гражанство</h5>
                            <span><?= $information->nationality ?></span>
                            </div>
                            <div class="col-md-auto">
                            <h5>Снилс</h5>
                            <span><?= $information->snils ?></span>
                            </div>
                            <div class="col-md-auto">
                                <h5>Скан снилса</h5>
                                <img src="../uploads/<?= $information->scan_snils ?>" class="scan" alt="">
                            </div>
                            <div class="col-md-auto">
                                <h5>Здоровье</h5>
                                <span><?= $information->health ?></span>
                            </div>
                            <div class="col-md-auto">
                                <h5>Допольнительная информация</h5>
                                <span><?= $information->more_information ?></span>
                            </div>
                        </div>
                        <?php else : ?>
                            <div class="row back">Вы еще не заполнили информацию!</div>
                        <?php endif; ?>
                        <br>
                        <?php if($information) : ?>
                                <a href=<?= Url::to(['information/update', 'id' => $information->id]) ?> class="btn btn-primary">Изменить</a>
                            <?php else : ?>
                                <a href=<?= Url::to(['information/create']) ?> class="btn btn-primary">Добавить</a>
                        <?php endif; ?>
                    </div>
                </div>
                <br>
                <div class="col">
                    <div class="container">
                        <h3>Паспортные данные</h3>
                        <?php if($passport) : ?>
                        <div class="row back">
                            <div class="col-md-auto">
                                <h5>Серия</h5>
                                <span><?= $passport->seria ?></span>
                            </div>
                            <div class="col-md-auto">
                            <h5>Номер</h5>
                            <span><?= $passport->number ?></span>
                            </div>
                            <div class="col-md-auto">
                            <h5>Когда выдан</h5>
                            <span><?= $passport->where_given ?></span>
                            </div>
                            <div class="col-md-auto">
                            <h5>Кем выдан</h5>
                            <span><?= $passport->who_given ?></span>
                            </div>
                            <div class="col-md-auto">
                                <h5>Семейное положение</h5>
                                <span><?= $passport->family_status ?></span>
                            </div>
                            <div class="col-md-auto">
                                <h5>Скан паспорта</h5>
                                <img src="../uploads/<?= $passport->scan_passport ?>" class="scan" alt="">
                            </div>
                        </div>
                        <?php else : ?>
                            <div class="row back">Вы еще не заполнили информацию!</div>
                        <?php endif; ?>
                        <br>
                        <?php if($passport) : ?>
                                <a href=<?= Url::to(['passport/update', 'id' => $passport->id]) ?> class="btn btn-primary">Изменить</a>
                            <?php else : ?>
                                <a href=<?= Url::to(['passport/create']) ?> class="btn btn-primary">Добавить</a>
                        <?php endif; ?>
                    </div>
                </div>
                <br>
                <div class="col">
                    <div class="container">
                        <h3>Образование</h3>
                        <?php if($education) : ?>
                        <div class="row back">
                            <div class="col-md-auto">
                                <h5>Образование</h5>
                                <span><?= $education->education->name ?></span>
                            </div>
                            <div class="col-md-auto">
                            <h5>Название образовательной организации</h5>
                            <span><?= $education->name_organization ?></span>
                            </div>
                            <div class="col-md-auto">
                            <h5>Специальность и квалификация по диплому</h5>
                            <span><?= $education->speciality ?></span>
                            </div>
                            <div class="col-md-auto">
                            <h5>Серия и номер диплома</h5>
                            <span><?= $education->seria_diplom . ' ' . $education->number_diplom ?></span>
                            </div>
                            <div class="col-md-auto">
                                <h5>Год окончания образовательной организации</h5>
                                <span><?= $education->year_end ?></span>
                            </div>
                            <div class="col-md-auto">
                                <h5>Скан документа</h5>
                                <img src="../uploads/<?= $education->scan_education ?>" class="scan" alt="">
                            </div>
                        </div>
                        <?php else : ?>
                            <div class="row back">Вы еще не заполнили информацию!</div>
                        <?php endif; ?>
                        <br>
                        <?php if($education) : ?>
                                <a href=<?= Url::to(['education/update', 'id' => $education->id]) ?> class="btn btn-primary">Изменить</a>
                            <?php else : ?>
                                <a href=<?= Url::to(['education/create']) ?> class="btn btn-primary">Добавить</a>
                        <?php endif; ?>
                    </div>
                </div>
                <br>
                <div class="col">
                    <div class="container">
                        <h3>Работа</h3>
                        <?php if($work) : ?>
                        <div class="row back">
                            <div class="col">
                                <h5>Место работы</h5>
                                <?php if($work) : ?>
                                <span><?= $work->place_work ?></span>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-auto">
                            <h5>Должность</h5>
                            <span><?= $work->position ?></span>
                            </div>
                            <div class="col-md-auto">
                            <h5>Стаж работы</h5>
                            <span><?= $work->exp_work ?> г.</span>
                            </div>
                        </div>
                        <?php else : ?>
                            <div class="row back">Вы еще не заполнили информацию!</div>
                        <?php endif; ?>
                        <br>
                        <?php if($work) : ?>
                                <a href=<?= Url::to(['work/update', 'id' => $work->id]) ?> class="btn btn-primary">Изменить</a>
                            <?php else : ?>
                                <a href=<?= Url::to(['work/create']) ?> class="btn btn-primary">Добавить</a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>