<?php
/** @var yii\web\View $this */
/** @var yii\bootstrap5\ActiveForm $form */

/** @var app\models\SendForm $model */
/** @var Numbers $numbers_id */

use app\models\Dost;
use app\models\Numbers;
use app\models\Pay;
use yii\bootstrap5\ActiveForm;
use yii\bootstrap5\Html;
use yii\helpers\ArrayHelper;
use yii\widgets\MaskedInput;
$this->title = 'Сформировать заявку';

?>

<div class="site-login " style="margin-top:3%;">
<h2><?= Html::encode($this->title) ?></h2>
            <div class="col-lg-5">
            <?php $form = ActiveForm::begin([
                'id' => 'login-form',
                'fieldConfig' => [
                    'template' => "{label}\n{input}\n{error}",
                    'labelOptions' => ['class' => 'col-lg-5 col-form-label mr-lg-3'],
                    'inputOptions' => ['class' => 'col-lg-3 form-control'],
                    'errorOptions' => ['class' => 'col-lg-7 invalid-feedback'],
                ],
                

                'options' => ['enctype' =>'multipart/form-data']
            ]); ?>
             
            <?= $form->field($model, 'numbers_id')->dropDownList(
                ArrayHelper::map(Numbers::find()->all(),'id','name')) ?>
 <?= $form->field($model, 'date')->textInput(['type' => 'date']) ?>
                <?= $form->field($model, 'dost_id')->dropDownList(
                ArrayHelper::map(Dost::find()->all(),'id','name')) ?>
                 <?= $form->field($model, 'desc_usluga')->textInput() ?>
                 
                
                

                <?= $form->field($model, 'pay_id')->dropDownList(
                ArrayHelper::map(Pay::find()->all(),'id','name')) ?>
                 <?= $form->field($model, 'kolvo')->textInput() ?>
           
           
            
          
     
          

            <div class="form-group">
                <div>
                    <?= Html::submitButton('Отправить', ['class' => 'btn btn-primary', 'name' => 'login-button']) ?>
                </div>
            </div>

            <?php ActiveForm::end(); ?>

        </div>
    </div>
</div>
